//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Study and generate different Line Codes - 2(Quaternary)

clear;
close;
clc;
x=[1 0 0 1 1 1 0 0]//Data Stream
//x=[0 0 0 1 1 0 1 1]//Data Stream
a=1;
//Polar NRZ
z=0;//Starting value on x axis
for i=1:2:length(x)
    subplot(2,1,1)
    g=gca();
    g.data_bounds=[0,-1.5;length(x),1.5]
    g.grid=[1,-1]
    title('Data')
        t=[z:1:z+1]//Plot range on x-axis (One bit period for current bit)
        plot(t,x(i))//Plot curent bit
        t=[z+1:1:z+2]//Plot range on x-axis (One bit period for next bit)
        plot(t,x(i+1))//Plot next bit

    
    subplot(2,1,2)
    g=gca();
    g.data_bounds=[0,-2;length(x),2]
    g.grid=[1,-1]
    title('2B1Q (Quaternary)')
        t=[z:2:z+2]//Plot range on x-axis (two bit periods for current and next bit)    
        if((x(i)==0)&(x(i+1)==0))//Check current and next bit combination
            plot(t,-3/2*a)//if 00 then plot -3/2*a
        elseif((x(i)==0)&(x(i+1)==1))//Check current and next bit combination
            plot(t,-1/2*a)//if 01 then plot -1/2*a
        elseif((x(i)==1)&(x(i+1)==0))//Check current and next bit combination
            plot(t,1/2*a)//if 10 then plot 1/2*a
        elseif((x(i)==1)&(x(i+1)==1))//Check current and next bit combination
            plot(t,3/2*a)//if 11 then plot 3/2*a
        end
    z=z+2//Increament starting value on x axis by two bits period
end
